<?php

namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\UserModel;
use Config\Services;

class MakeSessionFilter implements FilterInterface
{
    /**
     * Do whatever processing this filter needs to do.
     * By default it should not return anything during
     * normal execution. However, when an abnormal state
     * is found, it should return an instance of
     * CodeIgniter\HTTP\Response. If it does, script
     * execution will end and that Response will be
     * sent back to the client, allowing for error pages,
     * redirects, etc.
     *
     * @param RequestInterface $request
     * @param array|null       $arguments
     *
     * @return RequestInterface|ResponseInterface|string|void
     */


    protected $UserModel;

    public function __construct()
    {
        $this->UserModel = new UserModel();
    }


    public function before(RequestInterface $request, $arguments = null)
    {
        if (!session()->get('id')) {
        
            $cookies = $request->getCookie();
            
            // Check if cookies are set
            if (empty($cookies['rtuuidinds'])) {
                return; // Jika tidak ada cookie, keluar dari fungsi
            } 

            $id = $cookies['_rtuuidinds'] ?? null;
            $cookies_uuid = $cookies['rtuuidinds'];

            $this->UserModel->where('id',$id);
            $this->UserModel->where('cookies_uuid',$cookies_uuid);
            $user = $this->UserModel->first();

            if ($user) {

                $userData = [
                    'id'                => $user->id,
                    'name'              => $user->name,
                ];
                session()->set($userData);
            } else {
                $response = Services::response();
                $response->setCookie([
                    'name'   => 'rtuuidinds',
                    'value'  => '',
                    'expire' => -1, 
                    'path'   => '/',
                    'secure' => false,
                    'httponly' => true,
                ]);

                $response->setCookie([
                    'name'   => '_rtuuidinds',
                    'value'  => '',
                    'expire' => -1, 
                    'path'   => '/',
                    'secure' => false,
                    'httponly' => true,
                ]);
            }
        }

    }

    /**
     * Allows After filters to inspect and modify the response
     * object as needed. This method does not allow any way
     * to stop execution of other after filters, short of
     * throwing an Exception or Error.
     *
     * @param RequestInterface  $request
     * @param ResponseInterface $response
     * @param array|null        $arguments
     *
     * @return ResponseInterface|void
     */
    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        //
    }
}
