<?php

namespace App\Models;

use CodeIgniter\Model;

class LineModel extends Model
{
    protected $table            = 'tbl_line';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $returnType       = 'object';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = [];

    protected bool $allowEmptyInserts = false;
    protected bool $updateOnlyChanged = true;

    protected array $casts = [];
    protected array $castHandlers = [];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];



    public function getAllWithMachine()
    {
        $this->select('id, name');
        $lines = $this->findAll();

        if(empty( (array) $lines )){
            return $lines;
        }


        $data = [];
        foreach ($lines as $line) {
            $db = \Config\Database::connect();

            $query = $db->table('tbl_machine')
                        ->select('id, name, machine_no')
                        ->where('line_id', $line->id)
                        ->get();

            $line->machines = $query->getResultArray();
            $data[] = $line;


        }

        return $data;


    }





}
